package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.base.service.model.FvqSetting;
import com.yd.base.service.dao.FvqSettingMapper;
import com.yd.base.service.model.RelObjectCategory;
import com.yd.base.service.service.IFvqSettingService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 字段值查询配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-23
 */
@Service
public class FvqSettingServiceImpl extends ServiceImpl<FvqSettingMapper, FvqSetting> implements IFvqSettingService {

    /**
     * 查询列表
     * @param fieldBizIdList
     * @return
     */
    @Override
    public List<FvqSetting> queryList(List<String> fieldBizIdList) {
        List<FvqSetting> list = baseMapper.selectList(new LambdaQueryWrapper<FvqSetting>()
                .in(!CollectionUtils.isEmpty(fieldBizIdList),FvqSetting::getFieldBizId,fieldBizIdList)
        );
        return list;
    }


}
