package com.yd.base.feign.request.fieldvalue;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiFieldValueAddRequest {

    /**
     * 字段值
     */
    @NotBlank(message = "字段值不能为空")
    private String value;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 绑定的字段表唯一业务ID列表
     */
    @NotEmpty(message = "绑定的字段表唯一业务ID列表不能为空")
    private List<String> fieldBizIdList;
}
