package com.yd.base.feign.fallback.field;

import com.yd.base.feign.client.field.ApiFieldFeignClient;
import com.yd.base.feign.request.field.ApiFieldAddRequest;
import com.yd.base.feign.request.field.ApiFieldEditRequest;
import com.yd.base.feign.request.field.ApiFieldListRequest;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldDetailResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-字段信息Feign降级处理
 */
@Slf4j
@Component
public class ApiFieldFeignFallbackFactory implements FallbackFactory<ApiFieldFeignClient> {
    @Override
    public ApiFieldFeignClient create(Throwable cause) {
        return new ApiFieldFeignClient() {
            @Override
            public Result page(ApiFieldPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiFieldDetailResponse>> list(ApiFieldListRequest request) {
                return null;
            }

            @Override
            public Result add(ApiFieldAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiFieldEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiFieldDetailResponse> detail(String fieldBizId) {
                return null;
            }

            @Override
            public Result del(String fieldBizId) {
                return null;
            }
        };
    }
}
