/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectFieldService;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldListAddRequest;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldQueryRequest;
import com.yd.base.feign.response.relobjectfield.ApiRelObjectFieldQueryResponse;
import com.yd.base.service.model.RelObjectField;
import com.yd.base.service.service.IRelObjectFieldService;
import com.yd.common.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiRelObjectFieldServiceImpl
implements ApiRelObjectFieldService {
    private static final Logger log = LoggerFactory.getLogger(ApiRelObjectFieldServiceImpl.class);
    @Autowired
    private IRelObjectFieldService iRelObjectFieldService;

    @Override
    public Result<List<ApiRelObjectFieldQueryResponse>> query(ApiRelObjectFieldQueryRequest request) {
        List responses = this.iRelObjectFieldService.query(request);
        return Result.success((Object)responses);
    }

    @Override
    public Result addRelObjectFieldList(ApiRelObjectFieldListAddRequest request) {
        this.iRelObjectFieldService.delByObjectBizId(request.getObjectBizId());
        if (!CollectionUtils.isEmpty((Collection)request.getApiObjectFieldValueDtoList())) {
            List relObjectFieldList = request.getApiObjectFieldValueDtoList().stream().map(dto -> {
                RelObjectField relObjectField = new RelObjectField();
                BeanUtils.copyProperties((Object)request, (Object)relObjectField);
                BeanUtils.copyProperties((Object)dto, (Object)relObjectField);
                return relObjectField;
            }).collect(Collectors.toList());
            this.iRelObjectFieldService.saveOrUpdateBatch(relObjectFieldList);
        }
        return Result.success();
    }
}

