package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectSpeciesService;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesListAddRequest;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.base.service.model.RelObjectSpecies;
import com.yd.base.service.service.IRelObjectSpeciesService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelObjectSpeciesServiceImpl implements ApiRelObjectSpeciesService {

    @Autowired
    private IRelObjectSpeciesService iRelObjectSpeciesService;

    /**
     * 查询-对象规格关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectSpeciesQueryResponse>> query(ApiRelObjectSpeciesQueryRequest request) {
        List<ApiRelObjectSpeciesQueryResponse> responses = iRelObjectSpeciesService.query(request);
        return Result.success(responses);
    }

    /**
     * 添加-单个对象和规格列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectSpeciesList(ApiRelObjectSpeciesListAddRequest request) {
        //先删后新增
        //根据业务对象业务ID删除关系
        iRelObjectSpeciesService.delByObjectBizId(request.getObjectBizId());

        //新增
        if (!CollectionUtils.isEmpty(request.getSpeciesTypeBizIdList())) {
            //非空列表新增
            List<RelObjectSpecies> relObjectSpeciesList = request.getSpeciesTypeBizIdList()
                    .stream().map(bizId -> {
                        RelObjectSpecies relObjectSpecies = new RelObjectSpecies();
                        BeanUtils.copyProperties(request,relObjectSpecies);
                        relObjectSpecies.setSpeciesTypeBizId(bizId);
                        return relObjectSpecies;
                    }).collect(Collectors.toList());
            iRelObjectSpeciesService.saveOrUpdateBatch(relObjectSpeciesList);
        }
        return Result.success();
    }
}
