package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.response.category.ApiCategoryPageResponse;
import com.yd.base.service.dao.CategoryMapper;
import com.yd.base.service.dto.CategoryDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.service.ICategoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 分类表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class CategoryServiceImpl extends ServiceImpl<CategoryMapper, Category> implements ICategoryService {

    @Override
    public IPage<ApiCategoryPageResponse> page(Page<ApiCategoryPageResponse> page,
                                               ApiCategoryPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Category> queryList(CategoryDto dto) {
        List<Category> list = baseMapper.selectList(new LambdaQueryWrapper<Category>()
                .eq(StringUtils.isNotBlank(dto.getCategoryBizId()) && !dto.getIsExcludeMy(),Category::getCategoryBizId,dto.getCategoryBizId())
                .eq(StringUtils.isNotBlank(dto.getName()),Category::getName,dto.getName())
                .ne(dto.getIsExcludeMy(),Category::getCategoryBizId,dto.getCategoryBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param dto
     * @return
     */
    @Override
    public Category queryOne(CategoryDto dto) {
        return this.getOne(new LambdaQueryWrapper<Category>().eq(Category::getCategoryBizId,dto.getPid()));
    }
}
