package com.yd.base.feign.fallback.relobjectspecies;

import com.yd.base.feign.client.relobjectspecies.ApiRelObjectSpeciesFeignClient;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesListAddRequest;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-对象规格关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelObjectSpeciesFeignFallbackFactory implements FallbackFactory<ApiRelObjectSpeciesFeignClient> {
    @Override
    public ApiRelObjectSpeciesFeignClient create(Throwable cause) {
        return new ApiRelObjectSpeciesFeignClient() {
            @Override
            public Result<List<ApiRelObjectSpeciesQueryResponse>> query(ApiRelObjectSpeciesQueryRequest request) {
                return null;
            }

            @Override
            public Result addRelObjectSpeciesList(ApiRelObjectSpeciesListAddRequest request) {
                return null;
            }
        };
    }
}
