/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiSpeciesService;
import com.yd.base.feign.request.species.ApiSpeciesAddRequest;
import com.yd.base.feign.request.species.ApiSpeciesEditRequest;
import com.yd.base.feign.request.species.ApiSpeciesPageRequest;
import com.yd.base.feign.response.species.ApiSpeciesDetailResponse;
import com.yd.base.feign.response.species.ApiSpeciesPageResponse;
import com.yd.base.service.dto.SpeciesDto;
import com.yd.base.service.model.Species;
import com.yd.base.service.service.ISpeciesService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiSpeciesServiceImpl
implements ApiSpeciesService {
    private static final Logger log = LoggerFactory.getLogger(ApiSpeciesServiceImpl.class);
    @Autowired
    private ISpeciesService iSpeciesService;

    @Override
    public Result<IPage<ApiSpeciesPageResponse>> page(ApiSpeciesPageRequest request) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        IPage iPage = this.iSpeciesService.page(page, request);
        return Result.success((Object)iPage);
    }

    @Override
    public Result add(ApiSpeciesAddRequest request) {
        List speciesList = this.iSpeciesService.queryList(SpeciesDto.builder().value(request.getValue()).build());
        if (!CollectionUtils.isEmpty((Collection)speciesList)) {
            throw new BusinessException("\u89c4\u683c\u503c\u5df2\u5b58\u5728");
        }
        Species species = new Species();
        BeanUtils.copyProperties((Object)request, (Object)species);
        species.setSpeciesBizId(RandomStringGenerator.generateBizId16((String)CommonEnum.UID_TYPE_SPECIES.getCode()));
        this.iSpeciesService.saveOrUpdate((Object)species);
        return Result.success();
    }

    @Override
    public Result edit(ApiSpeciesEditRequest request) {
        Result<Species> result = this.checkSpeciesIsExist(request.getSpeciesBizId());
        Species species = (Species)result.getData();
        List speciesList = this.iSpeciesService.queryList(SpeciesDto.builder().value(request.getValue()).speciesBizId(request.getSpeciesBizId()).isExcludeMy(Boolean.valueOf(true)).build());
        if (!CollectionUtils.isEmpty((Collection)speciesList)) {
            throw new BusinessException("\u89c4\u683c\u503c\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)request, (Object)species);
        this.iSpeciesService.saveOrUpdate((Object)species);
        return Result.success();
    }

    @Override
    public Result<ApiSpeciesDetailResponse> detail(String speciesBizId) {
        Result<Species> result = this.checkSpeciesIsExist(speciesBizId);
        Species species = (Species)result.getData();
        ApiSpeciesDetailResponse response = new ApiSpeciesDetailResponse();
        BeanUtils.copyProperties((Object)species, (Object)response);
        return Result.success((Object)response);
    }

    @Override
    public Result del(String speciesBizId) {
        return null;
    }

    public Result<Species> checkSpeciesIsExist(String speciesBizId) {
        Species species = this.iSpeciesService.queryOne(speciesBizId);
        if (Objects.isNull(species)) {
            throw new BusinessException("\u89c4\u683c\u5bf9\u8c61\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return Result.success((Object)species);
    }
}

