/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.SpeciesTypeService;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeAddRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeEditRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypeDetailResponse;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypePageResponse;
import com.yd.base.service.dto.SpeciesTypeDto;
import com.yd.base.service.model.SpeciesType;
import com.yd.base.service.service.ISpeciesTypeService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SpeciesTypeServiceImpl
implements SpeciesTypeService {
    private static final Logger log = LoggerFactory.getLogger(SpeciesTypeServiceImpl.class);
    @Autowired
    private ISpeciesTypeService iSpeciesTypeService;

    public Result<IPage<ApiSpeciesTypePageResponse>> page(ApiSpeciesTypePageRequest request) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        IPage iPage = this.iSpeciesTypeService.page(page, request);
        return Result.success((Object)iPage);
    }

    public Result add(ApiSpeciesTypeAddRequest request) {
        List speciesList = this.iSpeciesTypeService.queryList(SpeciesTypeDto.builder().typeName(request.getTypeName()).build());
        if (!CollectionUtils.isEmpty((Collection)speciesList)) {
            throw new BusinessException("\u89c4\u683c\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        SpeciesType speciesType = new SpeciesType();
        BeanUtils.copyProperties((Object)request, (Object)speciesType);
        speciesType.setSpeciesTypeBizId(RandomStringGenerator.generateBizId16((String)CommonEnum.UID_TYPE_SPECIES_TYPE.getCode()));
        speciesType.setTypeCode(CodeGenerator.generate10Code((String)"SPECIES_TYPE_CODE"));
        this.iSpeciesTypeService.saveOrUpdate((Object)speciesType);
        return Result.success();
    }

    public Result edit(ApiSpeciesTypeEditRequest request) {
        Result result = this.checkSpeciesTypeIsExist(request.getSpeciesTypeBizId());
        SpeciesType speciesType = (SpeciesType)result.getData();
        List speciesList = this.iSpeciesTypeService.queryList(SpeciesTypeDto.builder().typeName(request.getTypeName()).speciesTypeBizId(request.getSpeciesTypeBizId()).isExcludeMy(Boolean.valueOf(true)).build());
        if (!CollectionUtils.isEmpty((Collection)speciesList)) {
            throw new BusinessException("\u89c4\u683c\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)request, (Object)speciesType);
        this.iSpeciesTypeService.saveOrUpdate((Object)speciesType);
        return Result.success();
    }

    public Result<ApiSpeciesTypeDetailResponse> detail(String speciesTypeBizId) {
        Result result = this.checkSpeciesTypeIsExist(speciesTypeBizId);
        SpeciesType speciesType = (SpeciesType)result.getData();
        ApiSpeciesTypeDetailResponse response = new ApiSpeciesTypeDetailResponse();
        BeanUtils.copyProperties((Object)speciesType, (Object)response);
        return Result.success((Object)response);
    }

    public Result del(String speciesTypeBizId) {
        return null;
    }

    public Result<SpeciesType> checkSpeciesTypeIsExist(String speciesTypeBizId) {
        SpeciesType speciesType = this.iSpeciesTypeService.queryOne(speciesTypeBizId);
        if (Objects.isNull(speciesType)) {
            throw new BusinessException("\u89c4\u683c\u7c7b\u578b\u5bf9\u8c61\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return Result.success((Object)speciesType);
    }
}

