/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectCategoryService;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.service.model.RelObjectCategory;
import com.yd.base.service.service.IRelObjectCategoryService;
import com.yd.common.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiRelObjectCategoryServiceImpl
implements ApiRelObjectCategoryService {
    private static final Logger log = LoggerFactory.getLogger(ApiRelObjectCategoryServiceImpl.class);
    @Autowired
    private IRelObjectCategoryService iRelObjectCategoryService;

    @Override
    public Result<List<ApiRelObjectCategoryQueryResponse>> query(ApiRelObjectCategoryQueryRequest request) {
        List responses = this.iRelObjectCategoryService.query(request);
        return Result.success((Object)responses);
    }

    @Override
    public Result addRelObjectCategoryList(ApiRelObjectCategoryListAddRequest request) {
        this.iRelObjectCategoryService.delByObjectBizId(request.getObjectBizId());
        if (!CollectionUtils.isEmpty((Collection)request.getCategoryBizIdList())) {
            List relObjectCategoryList = request.getCategoryBizIdList().stream().map(categoryBizId -> {
                RelObjectCategory relObjectCategory = new RelObjectCategory();
                BeanUtils.copyProperties((Object)request, (Object)relObjectCategory);
                relObjectCategory.setCategoryBizId(categoryBizId);
                return relObjectCategory;
            }).collect(Collectors.toList());
            this.iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }

    @Override
    public Result addRelCategoryObjectList(ApiRelCategoryObjectListAddRequest request) {
        this.iRelObjectCategoryService.delByCategoryBizId(request.getCategoryBizId());
        if (!CollectionUtils.isEmpty((Collection)request.getApiObjectDtoList())) {
            List relObjectCategoryList = request.getApiObjectDtoList().stream().map(dto -> {
                RelObjectCategory relObjectCategory = new RelObjectCategory();
                BeanUtils.copyProperties((Object)dto, (Object)relObjectCategory);
                relObjectCategory.setCategoryBizId(request.getCategoryBizId());
                return relObjectCategory;
            }).collect(Collectors.toList());
            this.iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }
}

