package com.yd.base.feign.fallback.species;

import com.yd.base.feign.client.species.ApiSpeciesFeignClient;
import com.yd.base.feign.request.species.ApiSpeciesAddRequest;
import com.yd.base.feign.request.species.ApiSpeciesEditRequest;
import com.yd.base.feign.request.species.ApiSpeciesPageRequest;
import com.yd.base.feign.response.species.ApiSpeciesDetailResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 基础数据服务-规格信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSpeciesFeignFallbackFactory implements FallbackFactory<ApiSpeciesFeignClient> {
    @Override
    public ApiSpeciesFeignClient create(Throwable cause) {
        return new ApiSpeciesFeignClient() {
            @Override
            public Result page(ApiSpeciesPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiSpeciesAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSpeciesEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiSpeciesDetailResponse> detail(String speciesBizId) {
                return null;
            }

            @Override
            public Result del(String speciesBizId) {
                return null;
            }
        };
    }
}
