package com.yd.base.service.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CategoryDto {

    /**
     * 分类类别（产品模块，资讯模块，活动模块等）
     */
    private String type;

    /**
     * 父id
     */
    private String pid;

    /**
     * 分类表唯一业务ID
     */
    private String categoryBizId;

    /**
     * 分类表唯一业务ID
     */
    private List<String> categoryBizIdList;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 是否排除当前categoryBizId
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
