package com.yd.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 字段表（字段属性表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("field")
public class Field implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 字段表唯一业务ID
     */
    @TableField("field_biz_id")
    private String fieldBizId;

    /**
     * 字段编码（唯一标识）
     */
    @TableField("field_code")
    private String fieldCode;

    /**
     * 字段中文名称
     */
    @TableField("field_cn_name")
    private String fieldCnName;

    /**
     * 字段英文名称
     */
    @TableField("field_en_name")
    private String fieldEnName;

    /**
     * 字段数据类型（varchar/int/decimal/date/datetime/text等）
     */
    @TableField("field_type")
    private String fieldType;

    /**
     * 字段长度
     */
    @TableField("field_length")
    private Integer fieldLength;

    /**
     * 字段精度（针对decimal类型）
     */
    @TableField("field_precision")
    private Integer fieldPrecision;

    /**
     * 是否必填：0-否，1-是
     */
    @TableField("is_required")
    private Integer isRequired;

    /**
     * 默认值
     */
    @TableField("default_value")
    private String defaultValue;

    /**
     * 字段排序
     */
    @TableField("field_order")
    private Integer fieldOrder;

    /**
     * 文本框类型
     */
    @TableField("text_box_type")
    private String textBoxType;

    /**
     * 状态：0-禁用，1-启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 字段说明备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识：0-正常，1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
