package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.ApiFieldValueService;
import com.yd.base.feign.client.fieldvalue.ApiFieldValueFeignClient;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueAddRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueEditRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueListRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValuePageRequest;
import com.yd.base.feign.response.fieldvalue.ApiFieldValueDetailResponse;
import com.yd.base.feign.response.fieldvalue.ApiFieldValuePageResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 字段值信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/fieldValue")
@Validated
public class ApiFieldValueController implements ApiFieldValueFeignClient {

    @Autowired
    private ApiFieldValueService apiFieldValueService;

    /**
     * 分页列表查询-字段值
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiFieldValuePageResponse>> page(ApiFieldValuePageRequest request) {
        return apiFieldValueService.page(request);
    }

    /**
     * 列表查询-字段值
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiFieldValueDetailResponse>> list(ApiFieldValueListRequest request) {
        return apiFieldValueService.list(request);
    }

    /**
     * 添加-字段值
     * @param request
     * @return
     */
    @Override
    public Result add(ApiFieldValueAddRequest request) {
        return apiFieldValueService.add(request);
    }

    /**
     * 编辑-字段值
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiFieldValueEditRequest request) {
        return apiFieldValueService.edit(request);
    }

    /**
     * 详情-字段值
     * @param fieldValueBizId 字段值表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiFieldValueDetailResponse> detail(String fieldValueBizId) {
        return apiFieldValueService.detail(fieldValueBizId);
    }

    /**
     * 删除-字段值 TODO
     * @param fieldValueBizId 字段值表唯一业务ID
     * @return
     */
    @Override
    public Result del(String fieldValueBizId) {
        return apiFieldValueService.del(fieldValueBizId);
    }
}
