package com.yd.base.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FieldValueDto {

    /**
     * 字段值表唯一业务ID
     */
    private String fieldValueBizId;

    /**
     * 字段值表唯一业务ID列表
     */
    private List<String> fieldValueBizIdList;

    /**
     * 字段值
     */
    private String value;

    /**
     * 是否排除当前fieldValueBizId
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
