package com.yd.base.feign.response.bank;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiBankDetailResponse {

    private Long id;

    /**
     * 银行基础信息表唯一业务ID
     */
    private String bankBizId;

    /**
     * 银行层级（银行层级：1-总行，2-分行，3-支行，4-分理处。）
     */
    private String bankLevel;

    /**
     * 上级行ID，关联本表主键。总行的 parent_bank_id = 0。
     */
    private String parentBankId;

    /**
     * 银行机构全称。例如：中国工商银行，中国工商银行北京市分行，中国工商银行北京海淀支行。
     */
    private String bankName;

    /**
     * 银行机构简称。例如：工行，工行北京分行，工行海淀支行
     */
    private String bankShortName;

    /**
     * 银行类型：1-央行，2-国有大行，3-股份制，4-城商行，5-农商行，6-外资行，7-邮储，8-香港银行，9-国际银行。
     */
    private String bankType;

    /**
     * 所属地区：1-大陆，2-香港，3-澳门，4-台湾，5-国际。
     */
    private String region;

    /**
     * 银行Logo URL。存储银行logo图片的链接地址。
     */
    private String logoUrl;

    /**
     * 客服电话。
     */
    private String customerServicePhone;

    /**
     * 官方网站。
     */
    private String officialWebsite;

    /**
     * 是否合作银行：1-是，0-否。标记与我司有业务合作的银行。
     */
    private String isCooperation;

    /**
     * 合作级别：1-战略合作，2-重要合作，3-一般合作。仅为合作银行设置。
     */
    private String cooperationLevel;

    /**
     * 合作开始日期
     */
    private LocalDateTime cooperationStartDate;

    /**
     * 合作结束日期。
     */
    private LocalDateTime cooperationEndDate;

    /**
     * 状态：1-有效，0-无效。
     */
    private Integer status;

    /**
     * 排序号。
     */
    private String sortOrder;

    /**
     * 是否热门。
     */
    private String isPopular;

    /**
     * 热门排序
     */
    private String popularOrder;

    /**
     * 开户所需资料
     */
    private String materials;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
