package com.yd.base.feign.fallback.relfieldvalue;

import com.yd.base.feign.client.relfieldvalue.ApiRelFieldValueFeignClient;
import com.yd.base.feign.request.relfieldvalue.ApiRelFieldValuePageRequest;
import com.yd.base.feign.request.relfieldvalue.GetFieldListRequest;
import com.yd.base.feign.response.relfieldvalue.GetFieldListResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-字段和字段值关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelFieldValueFeignFallbackFactory implements FallbackFactory<ApiRelFieldValueFeignClient> {
    @Override
    public ApiRelFieldValueFeignClient create(Throwable cause) {
        return new ApiRelFieldValueFeignClient() {
            @Override
            public Result page(ApiRelFieldValuePageRequest request) {
                return null;
            }

            @Override
            public Result<List<GetFieldListResponse>> getFieldList(GetFieldListRequest request) {
                return null;
            }
        };
    }
}
