package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiRelFieldValueService;
import com.yd.base.feign.request.relfieldvalue.ApiRelFieldValuePageRequest;
import com.yd.base.feign.response.category.ApiCategoryPageResponse;
import com.yd.base.feign.response.relfieldvalue.ApiRelFieldValuePageResponse;
import com.yd.base.service.model.RelFieldValue;
import com.yd.base.service.service.IRelFieldValueService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelFieldValueServiceImpl implements ApiRelFieldValueService {

    @Autowired
    private IRelFieldValueService iRelFieldValueService;

    /**
     * 保存字段值和字段的关系
     * @param fieldValueBizId
     * @param fieldBizIdList
     * @return
     */
    @Override
    public Result save(String fieldValueBizId, List<String> fieldBizIdList) {
        //先删后新增
        //根据字段值业务ID删除关系
        iRelFieldValueService.delByFieldValueBizId(fieldValueBizId);

        //新增
        if (!CollectionUtils.isEmpty(fieldBizIdList)) {
            List<RelFieldValue> relFieldValueList = fieldBizIdList.stream().map(fieldBizId -> {
                RelFieldValue relFieldValue = new RelFieldValue();
                relFieldValue.setFieldBizId(fieldBizId);
                relFieldValue.setFieldValueBizId(fieldValueBizId);
                return relFieldValue;
            }).collect(Collectors.toList());

            iRelFieldValueService.saveOrUpdateBatch(relFieldValueList);
        }
        return Result.success();
    }

    /**
     * 分页列表查询-字段和字段值关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelFieldValuePageResponse>> page(ApiRelFieldValuePageRequest request) {
        Page<ApiRelFieldValuePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelFieldValuePageResponse> iPage = iRelFieldValueService.page(page, request);
        return Result.success(iPage);
    }
}
