package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiRelFieldValueService;
import com.yd.base.feign.request.relfieldvalue.ApiRelFieldValuePageRequest;
import com.yd.base.feign.request.relfieldvalue.GetFieldListRequest;
import com.yd.base.feign.response.relfieldvalue.ApiRelFieldValuePageResponse;
import com.yd.base.feign.response.relfieldvalue.ApiRelFieldValueResponse;
import com.yd.base.feign.response.relfieldvalue.GetFieldListResponse;
import com.yd.base.feign.response.relfieldvalue.GetFieldValueListResponse;
import com.yd.base.service.dto.RelFieldValueDto;
import com.yd.base.service.model.RelFieldValue;
import com.yd.base.service.service.IFieldService;
import com.yd.base.service.service.IRelFieldValueService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelFieldValueServiceImpl implements ApiRelFieldValueService {

    @Autowired
    private IRelFieldValueService iRelFieldValueService;

    /**
     * 保存字段值和字段的关系
     * @param fieldValueBizId
     * @param fieldBizIdList
     * @return
     */
    @Override
    public Result save(String fieldValueBizId, List<String> fieldBizIdList) {
        //先删后新增
        //根据字段值业务ID删除关系
        iRelFieldValueService.delByFieldValueBizId(fieldValueBizId);

        //新增
        if (!CollectionUtils.isEmpty(fieldBizIdList)) {
            List<RelFieldValue> relFieldValueList = fieldBizIdList.stream().map(fieldBizId -> {
                RelFieldValue relFieldValue = new RelFieldValue();
                relFieldValue.setFieldBizId(fieldBizId);
                relFieldValue.setFieldValueBizId(fieldValueBizId);
                return relFieldValue;
            }).collect(Collectors.toList());

            iRelFieldValueService.saveOrUpdateBatch(relFieldValueList);
        }
        return Result.success();
    }

    /**
     * 分页列表查询-字段和字段值关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelFieldValuePageResponse>> page(ApiRelFieldValuePageRequest request) {
        Page<ApiRelFieldValuePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelFieldValuePageResponse> iPage = iRelFieldValueService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 根据字段ID列表获取字段值列表
     * @return
     */
    @Override
    public Result<List<GetFieldListResponse>> getFieldList(GetFieldListRequest request) {
        List<GetFieldListResponse> typeListResponseList = new ArrayList<>();

        // 检查字段ID列表是否为空
        if (CollectionUtils.isEmpty(request.getFieldBizIdList())) {
            return Result.success(typeListResponseList);
        }

        // 根据字段表唯一业务ID列表查询字段列表信息
        List<ApiRelFieldValueResponse> responses = iRelFieldValueService.list(
                RelFieldValueDto.builder().fieldBizIdList(request.getFieldBizIdList()).build());

        if (CollectionUtils.isEmpty(responses)) {
            return Result.success(typeListResponseList);
        }

        // 按字段ID分组
        Map<String, List<ApiRelFieldValueResponse>> fieldGroupMap = responses.stream()
                .collect(Collectors.groupingBy(ApiRelFieldValueResponse::getFieldBizId));

        for (String fieldBizId : request.getFieldBizIdList()) {
            List<ApiRelFieldValueResponse> fieldValues = fieldGroupMap.get(fieldBizId);

            if (CollectionUtils.isEmpty(fieldValues)) {
                continue;
            }

            ApiRelFieldValueResponse firstValue = fieldValues.get(0);

            GetFieldListResponse fieldResponse = new GetFieldListResponse();
            // 设置字段基本信息
            fieldResponse.setFieldBizId(firstValue.getFieldBizId());
            fieldResponse.setFieldCode(firstValue.getFieldCode());
            fieldResponse.setFieldCnName(firstValue.getFieldCnName());
            fieldResponse.setFieldEnName(firstValue.getFieldEnName());
            fieldResponse.setTextBoxType(firstValue.getTextBoxType());

            // 构建字段值列表
            List<GetFieldValueListResponse> valueList = fieldValues.stream()
                    .map(response -> {
                        GetFieldValueListResponse valueResponse = new GetFieldValueListResponse();
                        valueResponse.setFieldValueBizId(response.getFieldValueBizId());
                        valueResponse.setFieldValueCode(response.getFieldValueCode());
                        valueResponse.setValue(response.getValue());
                        return valueResponse;
                    })
                    .collect(Collectors.toList());

            fieldResponse.setFieldValueListResponseList(valueList);
            typeListResponseList.add(fieldResponse);
        }

        return Result.success(typeListResponseList);

    }
}
