package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.base.service.dao.RelObjectSpeciesMapper;
import com.yd.base.service.model.RelObjectSpecies;
import com.yd.base.service.service.IRelObjectSpeciesService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象规格关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelObjectSpeciesServiceImpl extends ServiceImpl<RelObjectSpeciesMapper, RelObjectSpecies> implements IRelObjectSpeciesService {

    @Override
    public List<ApiRelObjectSpeciesQueryResponse> query(ApiRelObjectSpeciesQueryRequest request) {
        return baseMapper.query(request);
    }

    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectSpecies>().eq(RelObjectSpecies::getObjectBizId,objectBizId));
    }

    @Override
    public Boolean delByObjectBizIdList(List<String> objectBizIdList) {
        return this.remove(new LambdaQueryWrapper<RelObjectSpecies>().in(RelObjectSpecies::getObjectBizId,objectBizIdList));
    }
}
