package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.fieldvalue.ApiFieldValuePageRequest;
import com.yd.base.feign.response.fieldvalue.ApiFieldValuePageResponse;
import com.yd.base.service.dao.FieldValueMapper;
import com.yd.base.service.dto.FieldValueDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.model.FieldValue;
import com.yd.base.service.service.IFieldValueService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 字段值表（字段字典） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class FieldValueServiceImpl extends ServiceImpl<FieldValueMapper, FieldValue> implements IFieldValueService {

    @Override
    public IPage<ApiFieldValuePageResponse> page(Page<ApiFieldValuePageResponse> page,
                                                 ApiFieldValuePageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<FieldValue> queryList(FieldValueDto dto) {
        List<FieldValue> list = baseMapper.selectList(new LambdaQueryWrapper<FieldValue>()
                .eq(StringUtils.isNotBlank(dto.getFieldValueBizId()) && !dto.getIsExcludeMy(),FieldValue::getFieldValueBizId,dto.getFieldValueBizId())
                .eq(StringUtils.isNotBlank(dto.getValue()),FieldValue::getValue,dto.getValue())
                .in(!CollectionUtils.isEmpty(dto.getFieldValueBizIdList()),FieldValue::getFieldValueBizId,dto.getFieldValueBizIdList())
                .ne(dto.getIsExcludeMy(),FieldValue::getFieldValueBizId,dto.getFieldValueBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param fieldValueBizId
     * @return
     */
    @Override
    public FieldValue queryOne(String fieldValueBizId) {
        return this.getOne(new LambdaQueryWrapper<FieldValue>().eq(FieldValue::getFieldValueBizId,fieldValueBizId));
    }
}
