package com.yd.base.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.feign.request.bank.ApiBankAddRequest;
import com.yd.base.feign.request.bank.ApiBankEditRequest;
import com.yd.base.feign.request.bank.ApiBankListRequest;
import com.yd.base.feign.request.bank.ApiBankPageRequest;
import com.yd.base.feign.response.bank.ApiBankDetailResponse;
import com.yd.base.feign.response.bank.ApiBankPageResponse;
import com.yd.common.result.Result;

import java.util.List;

public interface ApiBankService {
    Result<IPage<ApiBankPageResponse>> page(ApiBankPageRequest request);

    Result<List<ApiBankDetailResponse>> list(ApiBankListRequest request);

    Result add(ApiBankAddRequest request);

    Result edit(ApiBankEditRequest request);

    Result<ApiBankDetailResponse> detail(String bankBizId);

    Result del(String bankBizId);

    Result editStatus(String bankBizId, Integer status);
}
