package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.ApiSpeciesService;
import com.yd.base.feign.client.species.ApiSpeciesFeignClient;
import com.yd.base.feign.request.species.ApiSpeciesAddRequest;
import com.yd.base.feign.request.species.ApiSpeciesEditRequest;
import com.yd.base.feign.request.species.ApiSpeciesPageRequest;
import com.yd.base.feign.response.species.ApiSpeciesDetailResponse;
import com.yd.base.feign.response.species.ApiSpeciesPageResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 规格信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/species")
@Validated
public class ApiSpeciesController implements ApiSpeciesFeignClient {

    @Autowired
    private ApiSpeciesService apiSpeciesService;

    /**
     * 分页列表查询-规格
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSpeciesPageResponse>> page(ApiSpeciesPageRequest request) {
        return apiSpeciesService.page(request);
    }

    /**
     * 添加-规格
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSpeciesAddRequest request) {
        return apiSpeciesService.add(request);
    }

    /**
     * 编辑-规格
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSpeciesEditRequest request) {
        return apiSpeciesService.edit(request);
    }

    /**
     * 详情-规格
     * @param speciesBizId 规格表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiSpeciesDetailResponse> detail(String speciesBizId) {
        return apiSpeciesService.detail(speciesBizId);
    }

    /**
     * 删除-规格 TODO
     * @param speciesBizId 规格表唯一业务ID
     * @return
     */
    @Override
    public Result del(String speciesBizId) {
        return apiSpeciesService.del(speciesBizId);
    }
}
