package com.yd.base.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.dao")
@EnableFeignClients(basePackages = "com.yd")
public class BaseApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(BaseApiApplication.class)
                .properties("spring.application.name="+ ServerNameConstants.ydBaseApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-base-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
