package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.base.service.model.RelFieldValue;
import com.yd.base.service.dao.RelFieldValueMapper;
import com.yd.base.service.service.IRelFieldValueService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 字段和字段值关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-21
 */
@Service
public class RelFieldValueServiceImpl extends ServiceImpl<RelFieldValueMapper, RelFieldValue> implements IRelFieldValueService {

    /**
     * 根据字段值业务ID删除
     * @param fieldValueBizId
     * @return
     */
    @Override
    public Boolean delByFieldValueBizId(String fieldValueBizId) {
        return this.remove(new LambdaQueryWrapper<RelFieldValue>().eq(RelFieldValue::getFieldValueBizId,fieldValueBizId));
    }
}
