package com.yd.base.feign.fallback.speciestype;

import com.yd.base.feign.client.speciestype.ApiSpeciesTypeFeignClient;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeAddRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeEditRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypeDetailResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 基础数据服务-规格类型信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSpeciesTypeFeignFallbackFactory implements FallbackFactory<ApiSpeciesTypeFeignClient> {
    @Override
    public ApiSpeciesTypeFeignClient create(Throwable cause) {
        return new ApiSpeciesTypeFeignClient() {
            @Override
            public Result page(ApiSpeciesTypePageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiSpeciesTypeAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSpeciesTypeEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiSpeciesTypeDetailResponse> detail(String speciesTypeBizId) {
                return null;
            }

            @Override
            public Result del(String speciesTypeBizId) {
                return null;
            }
        };
    }
}
