/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiFieldService;
import com.yd.base.feign.request.field.ApiFieldAddRequest;
import com.yd.base.feign.request.field.ApiFieldEditRequest;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldDetailResponse;
import com.yd.base.feign.response.field.ApiFieldPageResponse;
import com.yd.base.service.dto.FieldDto;
import com.yd.base.service.model.Field;
import com.yd.base.service.service.IFieldService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiFieldServiceImpl
implements ApiFieldService {
    private static final Logger log = LoggerFactory.getLogger(ApiFieldServiceImpl.class);
    @Autowired
    private IFieldService iFieldService;

    @Override
    public Result<IPage<ApiFieldPageResponse>> page(ApiFieldPageRequest request) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        IPage iPage = this.iFieldService.page(page, request);
        return Result.success((Object)iPage);
    }

    @Override
    public Result add(ApiFieldAddRequest request) {
        Field field = new Field();
        BeanUtils.copyProperties((Object)request, (Object)field);
        field.setFieldBizId(RandomStringGenerator.generateBizId16((String)CommonEnum.UID_TYPE_FIELD.getCode()));
        field.setFieldCode(CodeGenerator.generate10Code((String)"FIELD"));
        this.iFieldService.saveOrUpdate((Object)field);
        return Result.success();
    }

    @Override
    public Result edit(ApiFieldEditRequest request) {
        Result<Field> result = this.checkFieldIsExist(request.getFieldBizId());
        Field field = (Field)result.getData();
        BeanUtils.copyProperties((Object)request, (Object)field);
        this.iFieldService.saveOrUpdate((Object)field);
        return Result.success();
    }

    @Override
    public Result<ApiFieldDetailResponse> detail(String fieldBizId) {
        Result<Field> result = this.checkFieldIsExist(fieldBizId);
        Field field = (Field)result.getData();
        ApiFieldDetailResponse response = new ApiFieldDetailResponse();
        BeanUtils.copyProperties((Object)field, (Object)response);
        return Result.success((Object)response);
    }

    @Override
    public Result del(String fieldBizId) {
        return null;
    }

    public Result<Field> checkFieldIsExist(String fieldBizId) {
        Field field = this.iFieldService.queryOne(FieldDto.builder().fieldBizId(fieldBizId).build());
        if (Objects.isNull(field)) {
            throw new BusinessException("\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return Result.success((Object)field);
    }
}

