package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypePageResponse;
import com.yd.base.service.dto.SpeciesTypeDto;
import com.yd.base.service.model.Species;
import com.yd.base.service.model.SpeciesType;
import com.yd.base.service.dao.SpeciesTypeMapper;
import com.yd.base.service.service.ISpeciesTypeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 规格类型表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-21
 */
@Service
public class SpeciesTypeServiceImpl extends ServiceImpl<SpeciesTypeMapper, SpeciesType> implements ISpeciesTypeService {

    @Override
    public IPage<ApiSpeciesTypePageResponse> page(Page<ApiSpeciesTypePageResponse> page,
                                                  ApiSpeciesTypePageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<SpeciesType> queryList(SpeciesTypeDto dto) {
        List<SpeciesType> list = baseMapper.selectList(new LambdaQueryWrapper<SpeciesType>()
                .eq(StringUtils.isNotBlank(dto.getSpeciesTypeBizId()) && !dto.getIsExcludeMy(),SpeciesType::getSpeciesTypeBizId,dto.getSpeciesTypeBizId())
                .eq(StringUtils.isNotBlank(dto.getTypeName()),SpeciesType::getTypeName,dto.getTypeName())
                .ne(dto.getIsExcludeMy(),SpeciesType::getSpeciesTypeBizId,dto.getSpeciesTypeBizId())
        );
        return list;
    }

    @Override
    public SpeciesType queryOne(String speciesTypeBizId) {
        return this.getOne(new LambdaQueryWrapper<SpeciesType>().eq(SpeciesType::getSpeciesTypeBizId,speciesTypeBizId));
    }
}
