package com.yd.base.feign.request.field;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiFieldAddRequest {

    /**
     * 字段中文名称
     */
    @NotBlank(message = "字段中文名称不能为空")
    private String fieldCnName;

    /**
     * 字段英文名称
     */
    @NotBlank(message = "字段英文名称不能为空")
    private String fieldEnName;

    /**
     * 字段数据类型（varchar/int/decimal/date/datetime/text等）
     */
    @NotBlank(message = "字段数据类型不能为空")
    private String fieldType;

    /**
     * 字段长度
     */
    @NotNull(message = "字段长度不能为空")
    private Integer fieldLength;

    /**
     * 字段精度（针对decimal类型）
     */
    private Integer fieldPrecision;

    /**
     * 是否必填：0-否，1-是
     */
    @NotNull(message = "是否必填不能为空")
    private Integer isRequired;

    /**
     * 默认值
     */
    private String defaultValue;

    /**
     * 字段排序
     */
    private Integer fieldOrder;

    /**
     * 状态：0-禁用，1-启用
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 字段说明备注
     */
    private String remark;
}
