package com.yd.base.feign.client.species;

import com.yd.base.feign.fallback.species.ApiSpeciesFeignFallbackFactory;
import com.yd.base.feign.request.species.ApiSpeciesAddRequest;
import com.yd.base.feign.request.species.ApiSpeciesEditRequest;
import com.yd.base.feign.request.species.ApiSpeciesPageRequest;
import com.yd.base.feign.response.species.ApiSpeciesDetailResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 基础数据服务-规格信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiSpeciesFeignFallbackFactory.class)
public interface ApiSpeciesFeignClient {

    /**
     * 分页列表查询-规格
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSpeciesPageRequest request);

    /**
     * 添加-规格
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSpeciesAddRequest request);

    /**
     * 编辑-规格
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSpeciesEditRequest request);

    /**
     * 详情-规格
     * @param speciesBizId 规格表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSpeciesDetailResponse> detail(@NotBlank(message = "规格表唯一业务ID能为空") @RequestParam(value = "speciesBizId") String speciesBizId);

    /**
     * 删除-规格
     * @param speciesBizId 规格表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "规格表唯一业务ID能为空") @RequestParam(value = "speciesBizId") String speciesBizId);
}
