package com.yd.base.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.base.feign.request.category.ApiCategoryAddRequest;
import com.yd.base.feign.request.category.ApiCategoryEditRequest;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.request.category.ApiCategoryTreeListRequest;
import com.yd.base.feign.response.category.ApiCategoryDetailResponse;
import com.yd.base.feign.response.category.ApiCategoryPageResponse;
import com.yd.base.feign.response.category.ApiCategoryTreeListResponse;

import java.util.List;

public interface ApiCategoryService {
    Result<IPage<ApiCategoryPageResponse>> page(ApiCategoryPageRequest request);

    Result<List<ApiCategoryTreeListResponse>> treeList(ApiCategoryTreeListRequest request);

    Result add(ApiCategoryAddRequest request);

    Result edit(ApiCategoryEditRequest request);

    Result<ApiCategoryDetailResponse> detail(String categoryBizId);

    Result del(String categoryBizId);
}
