package com.yd.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 银行基础信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("bank")
public class Bank implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 银行基础信息表唯一业务ID
     */
    @TableField("bank_biz_id")
    private String bankBizId;

    /**
     * 银行层级（银行层级：1-总行，2-分行，3-支行，4-分理处。）
     */
    @TableField("bank_level")
    private String bankLevel;

    /**
     * 上级行ID，关联本表主键。总行的 parent_bank_id = 0。
     */
    @TableField("parent_bank_id")
    private String parentBankId;

    /**
     * 银行机构全称。例如：中国工商银行，中国工商银行北京市分行，中国工商银行北京海淀支行。
     */
    @TableField("bank_name")
    private String bankName;

    /**
     * 银行机构简称。例如：工行，工行北京分行，工行海淀支行
     */
    @TableField("bank_short_name")
    private String bankShortName;

    /**
     * 银行类型：1-央行，2-国有大行，3-股份制，4-城商行，5-农商行，6-外资行，7-邮储，8-香港银行，9-国际银行。
     */
    @TableField("bank_type")
    private String bankType;

    /**
     * 所属地区：1-大陆，2-香港，3-澳门，4-台湾，5-国际。
     */
    @TableField("region")
    private String region;

    /**
     * 银行Logo URL。存储银行logo图片的链接地址。
     */
    @TableField("logo_url")
    private String logoUrl;

    /**
     * 客服电话。
     */
    @TableField("customer_service_phone")
    private String customerServicePhone;

    /**
     * 官方网站。
     */
    @TableField("official_website")
    private String officialWebsite;

    /**
     * 是否合作银行：1-是，0-否。标记与我司有业务合作的银行。
     */
    @TableField("is_cooperation")
    private String isCooperation;

    /**
     * 合作级别：1-战略合作，2-重要合作，3-一般合作。仅为合作银行设置。
     */
    @TableField("cooperation_level")
    private String cooperationLevel;

    /**
     * 合作开始日期
     */
    @TableField("cooperation_start_date")
    private LocalDateTime cooperationStartDate;

    /**
     * 合作结束日期。
     */
    @TableField("cooperation_end_date")
    private LocalDateTime cooperationEndDate;

    /**
     * 状态：1-有效，0-无效。
     */
    @TableField("status")
    private Integer status;

    /**
     * 排序号。
     */
    @TableField("sort_order")
    private String sortOrder;

    /**
     * 是否热门。
     */
    @TableField("is_popular")
    private String isPopular;

    /**
     * 热门排序
     */
    @TableField("popular_order")
    private String popularOrder;

    /**
     * 开户所需资料
     */
    @TableField("materials")
    private String materials;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
