package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldQueryRequest;
import com.yd.base.feign.response.relobjectfield.ApiRelObjectFieldQueryResponse;
import com.yd.base.service.dao.RelObjectFieldMapper;
import com.yd.base.service.model.RelObjectField;
import com.yd.base.service.service.IRelObjectFieldService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象字段关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelObjectFieldServiceImpl extends ServiceImpl<RelObjectFieldMapper, RelObjectField> implements IRelObjectFieldService {

    @Override
    public List<ApiRelObjectFieldQueryResponse> query(ApiRelObjectFieldQueryRequest request) {
        return baseMapper.query(request);
    }

    /**
     * 根据对象业务ID删除
     * @param objectBizId
     * @return
     */
    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectField>().eq(RelObjectField::getObjectBizId,objectBizId));
    }
}
