package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.ApiFieldService;
import com.yd.base.feign.client.field.ApiFieldFeignClient;
import com.yd.base.feign.request.field.ApiFieldAddRequest;
import com.yd.base.feign.request.field.ApiFieldEditRequest;
import com.yd.base.feign.request.field.ApiFieldListRequest;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldDetailResponse;
import com.yd.base.feign.response.field.ApiFieldPageResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 字段信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/field")
@Validated
public class ApiFieldController implements ApiFieldFeignClient {

    @Autowired
    private ApiFieldService apiFieldService;

    /**
     * 分页列表查询-字段
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiFieldPageResponse>> page(ApiFieldPageRequest request) {
        return apiFieldService.page(request);
    }

    /**
     * 列表查询-字段
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiFieldDetailResponse>> list(ApiFieldListRequest request) {
        return apiFieldService.list(request);
    }

    /**
     * 添加-字段
     * @param request
     * @return
     */
    @Override
    public Result add(ApiFieldAddRequest request) {
        return apiFieldService.add(request);
    }

    /**
     * 编辑-字段
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiFieldEditRequest request) {
        return apiFieldService.edit(request);
    }

    /**
     * 详情-字段
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiFieldDetailResponse> detail(String fieldBizId) {
        return apiFieldService.detail(fieldBizId);
    }

    /**
     * 删除-字段 TODO
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @Override
    public Result del(String fieldBizId) {
        return apiFieldService.del(fieldBizId);
    }
}
