package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldPageResponse;
import com.yd.base.service.dao.FieldMapper;
import com.yd.base.service.dto.FieldDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.model.Field;
import com.yd.base.service.service.IFieldService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 字段表（字段属性表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class FieldServiceImpl extends ServiceImpl<FieldMapper, Field> implements IFieldService {

    @Override
    public IPage<ApiFieldPageResponse> page(Page<ApiFieldPageResponse> page,
                                            ApiFieldPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param dto
     * @return
     */
    @Override
    public Field queryOne(FieldDto dto) {
        return this.getOne(new LambdaQueryWrapper<Field>().eq(Field::getFieldBizId,dto.getFieldBizId()));
    }

    @Override
    public List<Field> queryList(FieldDto dto) {
        List<Field> list = baseMapper.selectList(new LambdaQueryWrapper<Field>()
                .in(!CollectionUtils.isEmpty(dto.getFieldBizIdList()),Field::getFieldBizId,dto.getFieldBizIdList())
        );
        return list;
    }
}
