package com.yd.base.feign.request.category;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiCategoryAddRequest {

    /**
     * 分类类别（产品模块，资讯模块，活动模块等，字典）
     */
    private String type;

    /**
     * 父级id（分类表唯一业务ID）
     */
    @NotBlank(message = "父级id不能为空")
    private String pid;

    /**
     * 分类名称
     */
    @NotBlank(message = "分类名称不能为空")
    private String name;

    /**
     * 通用备注
     */
    private String remark;
}
