package com.yd.base.feign.fallback.bank;

import com.yd.base.feign.client.bank.ApiBankFeignClient;
import com.yd.base.feign.request.bank.ApiBankAddRequest;
import com.yd.base.feign.request.bank.ApiBankEditRequest;
import com.yd.base.feign.request.bank.ApiBankListRequest;
import com.yd.base.feign.request.bank.ApiBankPageRequest;
import com.yd.base.feign.response.bank.ApiBankDetailResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 基础数据服务-银行基础信息Feign降级处理
 */
@Slf4j
@Component
public class ApiBankFeignFallbackFactory implements FallbackFactory<ApiBankFeignClient> {
    @Override
    public ApiBankFeignClient create(Throwable cause) {
        return new ApiBankFeignClient() {
            @Override
            public Result page(ApiBankPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiBankDetailResponse>> list(ApiBankListRequest request) {
                return null;
            }

            @Override
            public Result add(ApiBankAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiBankEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiBankDetailResponse> detail(String bankBizId) {
                return null;
            }

            @Override
            public Result del(String bankBizId) {
                return null;
            }

            @Override
            public Result editStatus(String bankBizId, Integer status) {
                return null;
            }
        };
    }
}
