package com.yd.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 字段值查询配置表
 * </p>
 *
 * @author zxm
 * @since 2025-12-23
 */
@Getter
@Setter
@TableName("fvq_setting")
public class FvqSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 字段值查询配置表唯一业务ID
     */
    @TableField("fvq_setting_biz_id")
    private String fvqSettingBizId;

    /**
     * 字段表唯一业务ID
     */
    @TableField("field_biz_id")
    private String fieldBizId;

    /**
     * 请求数据URL
     */
    @TableField("req_url")
    private String reqUrl;

    /**
     * 请求方式
     */
    @TableField("req_method")
    private String reqMethod;

    /**
     * 请求参数（JSON串）
     */
    @TableField("req_param")
    private String reqParam;

    /**
     * 返回参数映射（JSON串）
     */
    @TableField("res_param_mapping")
    private String resParamMapping;

    /**
     * 状态：0-禁用，1-启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 字段说明备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识：0-正常，1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
