package com.yd.base.feign.fallback.category;

import com.yd.common.result.Result;
import com.yd.base.feign.client.category.ApiCategoryFeignClient;
import com.yd.base.feign.request.category.ApiCategoryAddRequest;
import com.yd.base.feign.request.category.ApiCategoryEditRequest;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.request.category.ApiCategoryTreeListRequest;
import com.yd.base.feign.response.category.ApiCategoryDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 基础数据服务-分类信息Feign降级处理
 */
@Slf4j
@Component
public class ApiCategoryFeignFallbackFactory implements FallbackFactory<ApiCategoryFeignClient> {
    @Override
    public ApiCategoryFeignClient create(Throwable cause) {
        return new ApiCategoryFeignClient() {
            @Override
            public Result page(ApiCategoryPageRequest request) {
                return null;
            }

            @Override
            public Result treeList(ApiCategoryTreeListRequest request) {
                return null;
            }

            @Override
            public Result add(ApiCategoryAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiCategoryEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiCategoryDetailResponse> detail(String categoryBizId) {
                return null;
            }

            @Override
            public Result del(String categoryBizId) {
                return null;
            }
        };
    }
}
