package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.SpeciesTypeService;
import com.yd.base.feign.dto.ApiSpeciesCustomizeDto;
import com.yd.base.feign.request.speciestype.ApiSpeciesCustomizeSaveRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeAddRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeEditRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypeDetailResponse;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypePageResponse;
import com.yd.base.service.dto.SpeciesTypeDto;
import com.yd.base.service.model.SpeciesType;
import com.yd.base.service.service.ISpeciesTypeService;
import com.yd.common.constant.CodeGeneratorConstants;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class ApiSpeciesTypeServiceImpl implements SpeciesTypeService {

    @Autowired
    private ISpeciesTypeService iSpeciesTypeService;

    /**
     * 分页列表查询-规格类型
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSpeciesTypePageResponse>> page(ApiSpeciesTypePageRequest request) {
        Page<ApiSpeciesTypePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSpeciesTypePageResponse> iPage = iSpeciesTypeService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加-规格类型
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSpeciesTypeAddRequest request) {
        //校验规格类型唯一性
        List<SpeciesType> speciesList =  iSpeciesTypeService.queryList(SpeciesTypeDto.builder()
                .typeName(request.getTypeName())
                .build());
        if (!CollectionUtils.isEmpty(speciesList)) {
            throw new BusinessException("规格类型已存在");
        }
        SpeciesType speciesType = new SpeciesType();
        BeanUtils.copyProperties(request,speciesType);
        speciesType.setSpeciesTypeBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_SPECIES_TYPE.getCode()));
        speciesType.setTypeCode(CodeGenerator.generate10Code(CodeGeneratorConstants.PREFIX_SPECIES_TYPE_CODE));
        iSpeciesTypeService.saveOrUpdate(speciesType);
        return Result.success();
    }

    /**
     * 编辑-规格类型
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSpeciesTypeEditRequest request) {
        Result<SpeciesType> result = checkSpeciesTypeIsExist(request.getSpeciesTypeBizId());
        SpeciesType speciesType = result.getData();
        //校验规格类型唯一性
        List<SpeciesType> speciesList =  iSpeciesTypeService.queryList(SpeciesTypeDto.builder()
                .typeName(request.getTypeName())
                .speciesTypeBizId(request.getSpeciesTypeBizId())
                .isExcludeMy(true)
                .build());
        if (!CollectionUtils.isEmpty(speciesList)) {
            throw new BusinessException("规格类型已存在");
        }
        BeanUtils.copyProperties(request,speciesType);
        iSpeciesTypeService.saveOrUpdate(speciesType);
        return Result.success();
    }

    /**
     * 详情-规格类型
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiSpeciesTypeDetailResponse> detail(String speciesTypeBizId) {
        Result<SpeciesType> result = checkSpeciesTypeIsExist(speciesTypeBizId);
        SpeciesType speciesType = result.getData();
        ApiSpeciesTypeDetailResponse response = new ApiSpeciesTypeDetailResponse();
        BeanUtils.copyProperties(speciesType,response);
        return Result.success(response);
    }

    /**
     * 删除-规格类型 TODO
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @Override
    public Result del(String speciesTypeBizId) {
        return null;
    }

    /**
     * 保存-规格自定义数据
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSpeciesCustomizeDto>> saveCustomize(ApiSpeciesCustomizeSaveRequest request) {
        //保存分类规格类型数据（对象规格）

        return null;
    }

    /**
     * 校验规格类型对象是否存在
     * @param speciesTypeBizId
     * @return
     */
    public Result<SpeciesType> checkSpeciesTypeIsExist(String speciesTypeBizId) {
        SpeciesType speciesType = iSpeciesTypeService.queryOne(speciesTypeBizId);
        if (Objects.isNull(speciesType)) {
            //数据不存在
            throw new BusinessException("规格类型对象数据不存在");
        }
        return Result.success(speciesType);
    }
}
