import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { EventBusService } from '../event-bus.service';
import { ActivatedRoute } from '@angular/router';
import { environment } from '../../environments/environment'
@Component({
  selector: 'app-broker-detail',
  templateUrl: './broker-detail.component.html',
  styleUrls: ['./broker-detail.component.css']
})
export class BrokerDetailComponent implements OnInit {
  certificateList: Array<any>;
  lifePhotoList: Array<any>;
  practitionerId: any;
  userPractitionerInfo: any;
  imgShowFlag: boolean;
  scaleImgPath: any;
  reloadurl: any;
  deviceType: number;
  constructor(private eventBusService: EventBusService, private activatedRoute: ActivatedRoute) {
  }

  ngOnInit() {
    this.practitionerId = this.activatedRoute.snapshot.params['id'];
    this.userPractitionerDetailQuery();
    this.reloadurl = window.location.hash + '?reload=true';
    if (this.getQuery('reload') !== 'true') {
      window.location.href = this.reloadurl;
    }

    this.deviceType = this.checkDeviceType();
  }
  userPractitionerDetailQuery() {
    const practitionerId = {
      practitionerId: this.practitionerId
    };
    this.eventBusService.userPractitionerDetailQuery(practitionerId).then(res => {
      if (res['success']) {
        this.userPractitionerInfo = res['data'];
        this.certificateList = this.userPractitionerInfo.certificateList;
        this.lifePhotoList = this.userPractitionerInfo.lifePhotoList;
      }
    });
  }

  scaleImg(path) {
    this.scaleImgPath = path;
    this.imgShowFlag = true;
  }

  getQuery(name) {
    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
    if (r != null) {
      return r[2];
    }
    return null;
  }

  //  分享名片
  shareIdCard() {
    const imgUrl = this.userPractitionerInfo.headFilePath ? this.userPractitionerInfo.headFilePath : `${environment.ORIGINNAME}/ydLife/assets/images/icons/meng.png`;
    this.eventBusService.shareStatusPublish(1);
    this.eventBusService.wxShare(
      `银盾保险经纪 ${this.userPractitionerInfo.name}`,
      '您的家庭保险专家、财务策划师。规划成就人生。',
      `${window.location.href}`,
      imgUrl);
  }


  /**
  * 检测设备信息
  * deviceType:PC为1,移动端为2,微信为3
  */
  checkDeviceType() {
    let deviceType = null;
    if (/Android|webOS|iPhone|iPod|BlackBerry/i.test(navigator.userAgent)) {
      if (navigator.userAgent.toLowerCase().indexOf('micromessenger') !== -1) {
        deviceType = 3;
      } else {
        deviceType = 2;
      }
    } else {
      deviceType = 1;
    }
    return deviceType;
  }
}
