import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service'
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-live',
  templateUrl: './live.component.html',
  styleUrls: ['./live.component.css']
})
export class LiveComponent implements OnInit {
  curPageData: Array<any>;
  provinceList: Array<any>;
  isShow: boolean;
  provinceId: number;
  provinceName: string;
  cityList: Array<any>;
  // 页面是否显示地址
  showAddress: boolean;
  // 入参地址
  address: any;
  // 页面地址
  strAddress: string;
  pageAnswers: any;
  type: any;
  nextBtn: boolean;
  lastQuestions: Array<any>;

  constructor(private commonService: CommonService,
              private router: Router,
              private route: ActivatedRoute) {
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.showAddress = false;
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 16).pop();
    // 获取省份
    this.commonService.provinceqry({insurerId: 11}).then(res => {
      if (res['success']) {
        this.provinceList = res['data'].provinceList;
      }
    })
    setTimeout(() => {
      this.surveyInfo()
    }, 200)


  }

  surveyInfo() {

    // 获取问题
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['15'];
        if (this.lastQuestions) {
          let customerInput = this.lastQuestions['questions'][0]['options'][0]['customerInput']
          customerInput = customerInput.split(',')
          const left = customerInput[0]
          const right = customerInput[1]
          if (this.provinceList.length > 0) {
            for (let i = 0; i < this.provinceList.length; i++) {
              if (this.provinceList[i].provinceName == left) {
                // console.log(this.provinceList[i])
                this.selectProvince(this.provinceList[i])

              }
            }
          }
          setTimeout(() => {
            for (let j = 0; j < this.cityList.length; j++) {
              if (this.cityList[j].cityName == right) {
                this.selectCity(this.cityList[j])
              }
            }
          }, 200)

        }

      }
    })

  }

  showToast() {
    this.isShow = true
  }

  selectProvince(option) {
    // console.log(this.selectedProvinceObj)
    this.provinceName = option.provinceName;
    this.provinceId = option.provinceId;
    for (let i = 0; i < this.provinceList.length; i++) {
      if (option['provinceId'] == this.provinceList[i]['provinceId']) {
        this.provinceList[i]['selected'] = true;
      } else {
        this.provinceList[i]['selected'] = false;
      }
    }
    this.getCityqry();
  }

  closeToast() {
    this.isShow = false;
  }

  getCityqry() {
    const param = {
      insurerId: 11,
      provinceId: this.provinceId
    }
    this.commonService.getCityqry(param).then(res => {
      if (res['success']) {
        this.cityList = res['data'].cityList;
      }
    })
  }

  selectCity(e) {
    this.showAddress = true;
    this.strAddress = this.provinceName + e.cityName;
    this.address = {
      customerInput: this.provinceName + ',' + e.cityName
    };
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [this.address]
      }],
    };
    this.commonService.addAnswer(this.pageAnswers);
    if (this.pageAnswers['questions'].length > 0) {
      this.nextBtn = true;
    } else {
      this.nextBtn = false;
    }
  }

  next() {
    if (this.nextBtn == true) {
      const param = {
        survey: {
          customerId: sessionStorage.getItem('customerId'),
          orderId: sessionStorage.getItem('orderId'),
          pages: this.commonService.todosCopy
        }
      };
      this.commonService.saveCustomerAnwers(param).then(res => {
        if (res['success']) {
          this.router.navigate(['/transit3']);
        } else {
        }
      });
    } else {
      return;
    }

  }

  //  上一步
  before() {
    this.commonService.before();
  }
}
