import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'

@Component({
  selector: 'app-page3',
  templateUrl: './page3.component.html',
  styleUrls: ['./page3.component.css']
})
export class Page3Component implements OnInit {
  @Input() curPageData: Array<any>
  @Input() isShowChildAgeBtn: boolean
  @Output() getAllAnswer = new EventEmitter<any>()

  isShow: boolean
  curQues: Object
  curAllQues: Object
  selectedNum: number
  options: Array<any>
  curQuesIndex: number
  //当前问题长度
  curQuesLen: number
  //增加孩子点击次数
  addChildCount: number
  constructor() {}

  ngOnInit() {
    this.curQues = {}
    this.curAllQues = {}
    this.curQuesLen = this.curPageData['questions'].length
    //初始化增加孩子按钮可以点2次
    this.addChildCount = 2
  }
  showToast(question, idx) {
    this.isShow = true
    this.curQues = question
    this.curQuesIndex = idx
  }
  closeToast() {
    this.isShow = false
  }
  getAnswer(option) {
    const questionId = this.curQues['questionId']
    this.curAllQues[questionId] = option
    const questions = Object.keys(this.curAllQues).map(questionId => {
      return { questionId, options: [this.curAllQues[questionId]] }
    })
    const ret = {
      pageId: 3,
      questions
    }
    this.getAllAnswer.emit(ret)
  }

  changeStyle(options, optionId) {
    //当前选中项
    this.curPageData['questions'][this.curQuesIndex]['name'] =
      options.optionName
    this.selectedNum = optionId
    // for (let i = 0; i < this.curQuesLen; i++) {
    //   for (
    //     let j = 0;
    //     j < this.curPageData['questions'][i]['options'].length;
    //     j++
    //   ) {
    //     if (
    //       options.optionId ==
    //       this.curPageData['questions'][i].options[j].optionId
    //     ) {

    //       this.curPageData['questions'][i]['name'] = this.curPageData[
    //         'questions'
    //       ][i].options[j].optionName
    //     }
    //   }
    // }
  }

  addChild() {
    // this.addChildCount--
    // if (this.addChildCount >= 0) {
    //   this.curPageData['questions'][this.curQuesLen++] = {
    //     questionId: 4,
    //     questionName: `孩子${this.addChildCount == 1 ? '1' : '2'}年龄`,
    //     optionType: 1,
    //     questionOrder: 4,
    //     options: [
    //       {
    //         optionId: 22,
    //         optionName: '９５后',
    //         optionOrder: 1,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 23,
    //         optionName: '９０后',
    //         optionOrder: 2,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 24,
    //         optionName: '８５后',
    //         optionOrder: 3,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 25,
    //         optionName: '８０后',
    //         optionOrder: 4,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 26,
    //         optionName: '７５后',
    //         optionOrder: 5,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 27,
    //         optionName: '７０后',
    //         optionOrder: 6,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 28,
    //         optionName: '６５后',
    //         optionOrder: 7,
    //         customerInput: null
    //       },
    //       {
    //         optionId: 29,
    //         optionName: '６０后',
    //         optionOrder: 8,
    //         customerInput: null
    //       }
    //     ]
    //   }
    // }
  }
}
