import { Component, OnInit } from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-smoking',
  templateUrl: './smoking.component.html',
  styleUrls: ['./smoking.component.css']
})
export class SmokingComponent implements OnInit {
  curPageData:Array<any>;
  type:any;
  nextBtn:boolean;
  pageAnswers:any;
  options:Array<any>;
  questions:Array<any> = [];

  constructor(
    private commonService: CommonService,
    private router: Router, 
    private route: ActivatedRoute
  ) { 
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.surveyInfo()
  }
  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['14']
        /**
         * 1:单身贵族
         * 2：二人世界
         * 3：独立带娃
         * 4：多口之家
         * @type {any}
         */
        //过滤选项
        if(this.type == 1){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 112 || option.optionId == 113
          })
        }
        if(this.type == 2){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 114 || option.optionId == 115 || option.optionId == 117
          })
        }
        if(this.type == 3){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 114 || option.optionId == 116 || option.optionId == 117
          })
        }
        if(this.type == 4){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 114 || option.optionId == 115 || option.optionId == 116 || option.optionId == 117
          })
        }
      }
    })
  }

  getOneAnswer(option){
    for(let i=0;i<this.options.length;i++){
      if(option['optionId']==this.options[i]['optionId']){
        this.options[i]['selected'] = true;
      }else{
        this.options[i]['selected'] = false;
      }
    }
    this.pageAnswers = {
      pageId : this.curPageData['pageId'],
      questions:[{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options:[option]
      }]
    }
    this.commonService.addAnswer(this.pageAnswers)
    console.log(this.pageAnswers)
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true
    }else{
      this.nextBtn = false
    }
  }

  getManyAnswer(option){
    option['selected'] = !option['selected'];
    this.questions = [];
    for (let i = 0; i < this.curPageData['questions'][0]['options'].length; i++) {
      if (option.optionId == 117 && option['selected']) {
        this.curPageData['questions'][0]['options'][i]['selected'] = false;
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 117) {
          this.curPageData['questions'][0]['options'][i]['selected'] = true;
        }
      } else {
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 117) {
          this.curPageData['questions'][0]['options'][i]['selected'] = false;
        }
      }
      // 拿到所有selected为true的选项
      if (this.curPageData['questions'][0]['options'][i]['selected']) {
        this.questions.push(this.curPageData['questions'][0]['options'][i]);
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: this.questions
      }],
    };
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true
    }else{
      this.nextBtn = false
    }
    console.log(this.pageAnswers)
    this.commonService.addAnswer(this.pageAnswers);
  }

  checkFun(option){
    if(this.type==1){
      this.getOneAnswer(option)
    }else{
      this.getManyAnswer(option)
    }
  }

  next(){
    if(this.nextBtn == true){
      this.router.navigate(['/live'],{queryParams:{type:this.type}})
    }else{
      return;
    }
  }
}
