import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {Router} from "@angular/router";
@Component({
  selector: 'app-family',
  templateUrl: './family.component.html',
  styleUrls: ['./family.component.css']
})
export class FamilyComponent implements OnInit {
  curPageData: Array<any>;
  pageAnswers: any;
  selectedOptionId: any;
  // 上一次的答案
  lastQuestions: Array<any>;
  // 上一次选择的optionId
  lastSelectedOptionId: any;
  nextBtn: boolean = false;
  targetObj: any = {};


  constructor(private commonService: CommonService, private router: Router) {
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 2).pop();
    this.commonService.surveyInfo().then(res => {
      this.curPageData = res['data']['survey']['pages'].filter(item => item.pageId === 2).pop();
      if (this.lastQuestions) {
        this.lastSelectedOptionId = this.lastQuestions['questions'][0]['options'][0]['optionId']
        for (let i = 0; i < this.lastQuestions['questions'].length; i++) {
          for (let j = 0; j < this.curPageData['questions'].length; j++) {
            if (this.lastQuestions['questions'][i].questionId == this.curPageData['questions'][j].questionId) {
              this.lastQuestions['questions'][i]['options'].forEach(option => {
                if (Object.keys(option).indexOf('optionId') > -1) {
                  this.targetObj = option;
                }
                this.selectedFamily(this.targetObj);
              });
            }
          }
        }
      }
    });

  }

//  选择家庭结构
  selectedFamily(option) {
    this.selectedOptionId = option.optionId;
    // 如果选择的跟上一次的家庭结构不一样，那么将以前的答案清空
    if (this.lastSelectedOptionId != this.selectedOptionId) {
      this.commonService.remove();
    }
    const options = this.curPageData['questions'][0]['options'];
    for (let i = 0; i < options.length; i++) {
      if (option['optionId'] == options[i]['optionId']) {
        options[i]['selected'] = true;
      } else {
        options[i]['selected'] = false;
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [option]
      }],
    };
    this.commonService.addAnswer(this.pageAnswers);
    // console.log(this.pageAnswers);
    if (this.curPageData['questions'].length == this.pageAnswers.questions.length) {
      this.nextBtn = true;
    } else {
      this.nextBtn = false;
    }
  }

//   下一步
  next() {
    if (this.nextBtn) {
      this.router.navigate(['/age'], {queryParams: {type: this.selectedOptionId}});
    } else {
      return;
    }
  }

//  上一步
  before() {
    this.commonService.before();
  }
}
