import { Component, OnInit ,Input} from '@angular/core';
import { CommonService } from '../common.service'
@Component({
  selector: 'app-page13',
  templateUrl: './page13.component.html',
  styleUrls: ['./page13.component.css']
})
export class Page13Component implements OnInit {
  @Input() curPageData: Array<any>
  isShow:boolean;
  provinceList:Array<any>;
  cityList:Array<any>;
  provinceId:number;
  constructor(private commonService:CommonService) { }

  ngOnInit() {
    console.log(this.curPageData)
    this.provinceqry()
  }

  showToast(){
    this.isShow = true;
  }
  closeToast(){
    this.isShow = false;
  }

  provinceqry(){
    this.commonService.provinceqry({insurerId:14}).subscribe(res => {
      if (res['success']) {
        this.provinceList = res['data'].provinceList
        console.log(this.provinceList)
      }
    })
  }

  getCityqry(){
    const param = {
      insurerId:14,
      provinceId:this.provinceId
    }
    this.commonService.provinceqry(param).subscribe(res => {
      if (res['success']) {
        console.log(res)
      }
    })
  }
}
