import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-disease',
  templateUrl: './disease.component.html',
  styleUrls: ['./disease.component.css']
})
export class DiseaseComponent implements OnInit {
  curPageData:any;
  type: any;
  pageAnswers: any;
  nextBtn: boolean;
  options: Array<any>;
  questions: Array<any> = [];
  lastQuestions: Array<any>;
  constructor(private commonService: CommonService,
              private router: Router,
              private route: ActivatedRoute) {
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 14).pop();    
    this.surveyInfo();
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['13']
        //过滤页面数据
        this.filterOptions(this.type)
        if(this.lastQuestions){
          for (let i = 0; i < this.lastQuestions['questions'].length; i++) {
            for (let j = 0; j < this.curPageData['questions'].length; j++) {
              if (this.lastQuestions['questions'][i].questionId == this.curPageData['questions'][j].questionId) {
                this.lastQuestions['questions'][i]['options'].forEach(option => {
                  if (Object.keys(option).indexOf('optionId') > -1) {
                    const targetObj = option;
                    this.curPageData['questions'][j]['options'].forEach(option => {
                      if (targetObj['optionId'] == option['optionId']) {
                        this.curPageData['questions'][j]['options'][this.curPageData['questions'][j]['options'].indexOf(option)] = targetObj;
                        // 过滤选项
                        this.filterOptions(this.type)
                        // console.log(targetObj)
                      }
                    });
                    if (this.type == 1) {
                      this.getOneAnswer(targetObj)
                    } else {
                      console.log(targetObj)
                      this.getManyAnswer(targetObj,true)
                    }
                  }
                });
              }
            }
          }
        }
      }
    })
  }

  getOneAnswer(option) {
    for (let i = 0; i < this.options.length; i++) {
      if (option['optionId'] == this.options[i]['optionId']) {
        this.options[i]['selected'] = true;
      } else {
        this.options[i]['selected'] = false;
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [option]
      }]
    }
    this.commonService.addAnswer(this.pageAnswers)
    // console.log(this.pageAnswers)
    if (this.curPageData['questions'].length == this.pageAnswers.questions.length) {
      if (this.pageAnswers.questions.every(item => item.options.length > 0)) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      this.nextBtn = false;
    }
  }

  getManyAnswer(option,lastFlag) {
    if (lastFlag === false) {
      option['selected'] = !option['selected'];
    }
    this.questions = [];
    for (let i = 0; i < this.curPageData['questions'][0]['options'].length; i++) {
      if (option.optionId == 111 && option['selected']) {
        this.curPageData['questions'][0]['options'][i]['selected'] = false;
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 111) {
          this.curPageData['questions'][0]['options'][i]['selected'] = true;
        }
      } else {
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 111) {
          this.curPageData['questions'][0]['options'][i]['selected'] = false;
        }
      }
      // 拿到所有selected为true的选项
      if (this.curPageData['questions'][0]['options'][i]['selected']) {
        this.questions.push(this.curPageData['questions'][0]['options'][i]);
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: this.questions
      }],
    };
    if (this.curPageData['questions'].length == this.pageAnswers.questions.length) {
      if (this.pageAnswers.questions.every(item => item.options.length > 0)) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      this.nextBtn = false;
    }
    // console.log(this.pageAnswers)
    this.commonService.addAnswer(this.pageAnswers);
  }

  // 根据type区分单选多选
  checkFun(option) {
    if (this.type == 1) {
      this.getOneAnswer(option)
    } else {
      this.getManyAnswer(option,false)
    }
  }

  next() {
    if (this.nextBtn == true) {
      this.router.navigate(['/smoke'], {queryParams: {type: this.type}})
    } else {
      return
    }
  }

  //过滤页面选项
  filterOptions(type){
      if (type == 1) {
        this.options = this.curPageData['questions']['0']['options']
        this.options = this.options.filter(option => {
          return option.optionId == 106 || option.optionId == 107
        })
      }
      if (type == 2) {
        this.options = this.curPageData['questions']['0']['options']
        this.options = this.options.filter(option => {
          return option.optionId == 108 || option.optionId == 109 || option.optionId == 111
        })
      }
      if (type == 3) {
        this.options = this.curPageData['questions']['0']['options']
        this.options = this.options.filter(option => {
          return option.optionId == 108 || option.optionId == 110 || option.optionId == 111
        })
      }
      if (type == 4) {
        this.options = this.curPageData['questions']['0']['options']
        this.options = this.options.filter(option => {
          return option.optionId == 108 || option.optionId == 109 || option.optionId == 110 || option.optionId == 111
        })
      }
  }
  //  上一步
  before() {
    this.commonService.before();
  }
}
