import {Component, OnInit} from '@angular/core';
import {Router} from '@angular/router';
import {EventBusService} from '../event-bus.service';

@Component({
  selector: 'app-broker-qry',
  templateUrl: './broker-qry.component.html',
  styleUrls: ['./broker-qry.component.css']
})
export class BrokerQryComponent implements OnInit {
  userPractitionerQueryItemList: Array<any>;
  practitionerName: string;

  constructor(private router: Router, private eventBusService: EventBusService) {
  }

  ngOnInit() {
  }

  // 经纪人查询
  userPractitionerQuery() {
    const userPractitioner = {
      name: this.practitionerName
    };
    this.eventBusService.userPractitionerQuery(userPractitioner).then(res => {
      if (res['success']) {
        this.userPractitionerQueryItemList = res['data'].userPractitionerQueryItemList;
      }
    });
  }

  // 经纪人详情信息查询
  viewDetail(id) {
    this.router.navigate(['brokerDetail', id]);
  }
}
