import { Component, OnInit } from '@angular/core'
import { CommonService } from '../common.service'
import { Options } from 'selenium-webdriver/chrome'
@Component({
  selector: 'app-ask',
  templateUrl: './ask.component.html',
  styleUrls: ['./ask.component.css']
})
export class AskComponent implements OnInit {
  allQues: Array<any>
  curPage: number
  totalPage: number
  curQues: string
  curPageData: Object
  allAnswers: Array<any>
  isShowChildAgeBtn: boolean
  hasMate: boolean
  constructor(private commonService: CommonService) {}

  ngOnInit() {
    this.curPage = 0
    this.totalPage = 17
    this.curPageData = []
    this.allAnswers = []
    this.isShowChildAgeBtn = true
    this.hasMate = true
    this.surveyInfo()
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.allQues = res['data']['survey'].pages
        this.curPageData = this.allQues[this.curPage]
      }
    })
  }
  reducePage() {
    if (this.curPage > 0) {
      this.curPage--
      this.setCurPageData()
    } else {
      return
    }
  }

  addPage() {
    if (this.curPage < 16) {
      if (
        this.curPage == 0 ||
        this.allAnswers[this.curPage] ||
        this.curPage == 5 ||
        this.curPage == 9
      ) {
        this.curPage++
        this.setCurPageData()
      }
    } else {
      this.curPage = 0
      return
    }
    console.log(this.curPage)
  }
  getAllAnswer(e) {
    this.allAnswers[this.curPage] = e
    console.log(this.allAnswers)
  }
  setCurPageData() {
    const thePateData = this.allQues[this.curPage]
    console.log('thePateData------', this.curPage, thePateData)
    this.curPageData = thePateData
    const page2Answer = this.allAnswers[1]
    if (this.curPage == 2) {
      this.filterPage2(
        page2Answer.questions[0].options[0].optionId,
        thePateData
      )
    }
    if (this.curPage == 4) {
      this.filterPage5(
        page2Answer.questions[0].options[0].optionId,
        thePateData
      )
    }
    if (this.curPage == 11) {
      this.filterPage12(
        page2Answer.questions[0].options[0].optionId,
        thePateData
      )
    }
    if (this.curPage == 12) {
      this.filterPage13(
        page2Answer.questions[0].options[0].optionId,
        thePateData
      )
    }
    console.log('page start', this.curPage)
    if (this.curPage == 13) {
      console.log('page end', this.curPage)
      this.filterPage14(
        page2Answer.questions[0].options[0].optionId,
        this.allQues[this.curPage]
      )
    }
  }

  filterPage2(optionId, thePateData) {
    //判断第二页选择家庭1单身2二人3独立带娃4多口
    if (optionId == 1 || optionId == 2) {
      this.isShowChildAgeBtn = false
    } else {
      this.isShowChildAgeBtn = true
    }
    //判断页面是否有配偶选项
    if (optionId == 1 || optionId == 3) {
      this.hasMate = false
    } else {
      this.hasMate = true
    }
    //单身贵族->您的年龄
    if (optionId == 1) {
      this.curPageData = {
        ...thePateData,
        questions: thePateData.questions.filter(question => {
          return question.questionId == 2
        })
      }
      return
    }
    //二人世界->您的年龄&配偶年龄
    if (optionId == 2) {
      this.curPageData = {
        ...thePateData,
        questions: thePateData.questions.filter(question => {
          return question.questionId <= 3
        })
      }
      return
    }
    //单亲->您的年龄&孩子年龄
    if (optionId == 3) {
      this.curPageData = {
        ...thePateData,
        questions: thePateData.questions.filter(question => {
          return question.questionId == 2 || question.questionId == 4
        })
      }
    }
  }

  filterPage5(optionId, thePateData) {
    //page5判断是否显示配偶工作页
    //1单身 3单亲
    if (optionId == 1 || optionId == 3) {
      this.curPage++
      console.log('page5', this.curPage, this.curPageData)
      this.curPageData = this.allQues[this.curPage]
    }
  }

  //pege12判断是否显示配偶健康
  filterPage12(optionId, thePateData) {
    if (optionId == 1 || optionId == 3) {
      this.curPage++
      this.curPageData = this.allQues[this.curPage]
    }
  }

  //page13判断是否显示孩子健康
  filterPage13(optionId, thePateData) {
    //单身或二人世界
    if (optionId == 1 || optionId == 2) {
      this.curPage++
    }
  }

  //page14判断option内容
  filterPage14(optionId, thePateData) {
    //如果单身或者单亲选择相中没有配偶选项
    if (optionId == 1) {
      this.curPageData = {
        ...thePateData,
        questions: [
          {
            ...thePateData.questions[0],
            options: thePateData.questions[0]['options'].filter(option => {
              return option.optionId == 106 || option.optionId == 107
            })
          }
        ]
      }
    }
    if (optionId == 2) {
      this.curPageData = {
        ...thePateData,
        questions: [
          {
            ...thePateData.questions[0],
            options: thePateData.questions[0]['options'].filter(option => {
              return (
                option.optionId == 108 ||
                option.optionId == 109 ||
                option.optionId == 111
              )
            })
          }
        ]
      }
    }
    if (optionId == 3) {
      this.curPageData = {
        ...thePateData,
        questions: [
          {
            ...thePateData.questions[0],
            options: thePateData.questions[0]['options'].filter(option => {
              return (
                option.optionId == 108 ||
                option.optionId == 110 ||
                option.optionId == 111
              )
            })
          }
        ]
      }
    }
    if (optionId == 4) {
      this.curPageData = {
        ...thePateData,
        questions: [
          {
            ...thePateData.questions[0],
            options: thePateData.questions[0]['options'].filter(option => {
              return (
                option.optionId == 108 ||
                option.optionId == 109 ||
                option.optionId == 110 ||
                option.optionId == 111
              )
            })
          }
        ]
      }
    }
  }
}
