import {Injectable} from '@angular/core';
import {environment} from './../environments/environment';
import {HttpClient, HttpHeaders} from '@angular/common/http';
@Injectable()
export class EventBusService {
  private USER_API_URL = '';
  private httpOptions;

  constructor(private http: HttpClient) {
    this.USER_API_URL = environment.apiUrl;
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json',
        'X-Authorization': ''
      })
    };
  }

  /**
   * 获取TOKEN
   */
  obtainToken() {
    const url = this.USER_API_URL + '/authorize/obtainToken';
    const ticketObj = {
      ticket: 'brokerQry'
    };
    return this.http.post(url, JSON.stringify(ticketObj), this.httpOptions).toPromise();
  }

  /**
   * 经纪人查询
   */
  async userPractitionerQuery(userPractitioner) {
    const url = this.USER_API_URL + '/user/userPractitionerQuery';
    const res = await this.obtainToken();
    this.httpOptions.headers = this.httpOptions.headers.set('X-Authorization', res['data']['token']);
    return this.http.post(url, JSON.stringify(userPractitioner), this.httpOptions)
      .toPromise().then(response => {
        return response;
      });
  }

  /**
   * 经纪人详细查询
   */
  async userPractitionerDetailQuery(userPractitionerDetail) {
    const url = this.USER_API_URL + '/user/userPractitionerDetailQuery';
    const res = await this.obtainToken();
    this.httpOptions.headers = this.httpOptions.headers.set('X-Authorization', res['data']['token'])
    return this.http.post(url, JSON.stringify(userPractitionerDetail), this.httpOptions)
      .toPromise().then(response => {
        return response;
      });
  }

}
